jQuery(document).ready(function($) {

    var itemSelector = '.grid-item';

    var $container = $('#container').isotope({
        itemSelector: itemSelector,
        masonry: {
            columnWidth: itemSelector,
            isFitWidth: true
        }
    });

    var responsiveIsotope = [
        [480, 7],
        [720, 10]
    ];

    var itemsPerPageDefault = 12;
    var itemsPerPage = defineItemsPerPage();
    var currentNumberPages = 1;
    var currentPage = 1;
    var currentFilter = '*';
    var filterAtribute = 'data-filter';
    var pageAtribute = 'data-page';
    var pagerClass = 'isotope-pager';

    function changeFilter(selector) {
        $container.isotope({ filter: selector });
    }

    function goToPage(n) {
        currentPage = n;
        var selector = itemSelector;
        selector += (currentFilter != '*') ? '[' + filterAtribute + '="' + currentFilter + '"]' : '';
        selector += '[' + pageAtribute + '="' + currentPage + '"]';
        changeFilter(selector);
    }

    function defineItemsPerPage() {
        var pages = itemsPerPageDefault;
        for (var i = 0; i < responsiveIsotope.length; i++) {
            if ($(window).width() <= responsiveIsotope[i][0]) {
                pages = responsiveIsotope[i][1];
                break;
            }
        }
        return pages;
    }

    function setPagination() {
        (function() {
            var itemsLength = $container.children(itemSelector).length;
            var pages = Math.ceil(itemsLength / itemsPerPage);
            var item = 1;
            var page = 1;
            var selector = itemSelector;
            selector += (currentFilter != '*') ? '[' + filterAtribute + '="' + currentFilter + '"]' : '';

            $container.children(selector).each(function() {
                if (item > itemsPerPage) {
                    page++;
                    item = 1;
                }
                $(this).attr(pageAtribute, page);
                item++;
            });

            currentNumberPages = page;
        })();

        (function() {
            var $isotopePager = ($('.' + pagerClass).length == 0) ? $('<div class="' + pagerClass + '"></div>') : $('.' + pagerClass);
            $isotopePager.html('');

            for (var i = 0; i < currentNumberPages; i++) {
                var $pager = $('<a href="javascript:void(0);" class="pager" ' + pageAtribute + '="' + (i + 1) + '"></a>');
                $pager.html(i + 1);

                $pager.click(function() {
                    var page = $(this).eq(0).attr(pageAtribute);
                    goToPage(page);
                    $('.' + pagerClass + ' a').removeClass('active');
                    $(this).addClass('active');
                });

                $pager.appendTo($isotopePager);
            }

            $container.after($isotopePager);
        })();
    }

    setPagination();
    goToPage(1);

    $('.filters a').click(function(e) {
        e.preventDefault();
        var filter = $(this).attr(filterAtribute);
        currentFilter = filter;
        setPagination();
        goToPage(1);
        $('.filters a').removeClass('active');
        $(this).addClass('active');
    });

    $(window).resize(function() {
        itemsPerPage = defineItemsPerPage();
        setPagination();
    });

    // Filter group
    $('.filter-button-group').on('click', 'li', function() {
        var filterValue = $(this).attr('data-filter');
        $('.grid').isotope({ filter: filterValue });
        $('.filter-button-group li').removeClass('active');
        $(this).addClass('active');
    });

    // Pager click event
    $('.isotope-pager').on('click', 'a', function() {
        var filterValue = $(this).attr('data-page');
        $('.isotope-pager a').removeClass('active');
        $(this).addClass('active');
    });

    // Magnific Popup
    $('.popupimg').magnificPopup({
        type: 'image',
        mainClass: 'mfp-with-zoom',
        gallery: {
          enabled: true
        },
        zoom: {
          enabled: true,
          duration: 300,
          easing: 'ease-in-out',
          opener: function(openerElement) {
            var bg = openerElement.find('.bg-image');
            return bg.length ? bg : openerElement; // safe fallback
          }
        }
      });
      

});



public function update($form, $data) {
    $post_id = $data['id']; // The post/page ID Beaver Builder is editing
    $settings = $data['settings'];

    // Example: get gallery images from settings
    $gallery_data = isset($settings->gallery_images) ? $settings->gallery_images : [];

    // Encode and save to custom field
    if (!empty($gallery_data)) {
        $encoded_json = wp_json_encode($gallery_data, JSON_UNESCAPED_UNICODE);
        update_post_meta($post_id, '_az_gallery_images', $encoded_json);
    } else {
        delete_post_meta($post_id, '_az_gallery_images'); // Clean up if empty
    }
}

